<?php
session_start();
require_once 'config.php';

echo "<h1>Database Verification</h1>";

$tables_to_check = ['users', 'staff', 'staff_assignments', 'bookings'];

foreach ($tables_to_check as $table) {
    $query = "SHOW TABLES LIKE '$table'";
    $result = $conn->query($query);
    
    if ($result && $result->num_rows > 0) {
        echo "<div style='background: #e5ffe5; padding: 10px; margin: 10px 0; color: green;'><strong>✓</strong> Table <strong>$table</strong> EXISTS</div>";
        
        // Show columns
        $colQuery = "DESCRIBE $table";
        $colResult = $conn->query($colQuery);
        $columns = [];
        while ($col = $colResult->fetch_assoc()) {
            $columns[] = $col['Field'];
        }
        echo "<p style='margin-left: 20px; color: #666;'>Columns: " . implode(", ", $columns) . "</p>";
    } else {
        echo "<div style='background: #ffe5e5; padding: 10px; margin: 10px 0; color: red;'><strong>✗</strong> Table <strong>$table</strong> NOT FOUND</div>";
    }
}

echo "<h2>Admin User Check</h2>";
$adminQuery = "SELECT id, name, email, user_type FROM users WHERE user_type = 'admin' LIMIT 1";
$adminResult = $conn->query($adminQuery);

if ($adminResult && $adminResult->num_rows > 0) {
    $admin = $adminResult->fetch_assoc();
    echo "<div style='background: #e5ffe5; padding: 15px; color: green;'>";
    echo "<strong>✓ Admin Found:</strong><br>";
    echo "ID: " . $admin['id'] . "<br>";
    echo "Name: " . $admin['name'] . "<br>";
    echo "Email: " . $admin['email'] . "<br>";
    echo "Type: " . $admin['user_type'];
    echo "</div>";
} else {
    echo "<div style='background: #ffe5e5; padding: 15px; color: red;'><strong>✗ No admin user found in users table</strong></div>";
}

echo "<h2>Sample Data Counts</h2>";

$tables_data = [
    'users' => "SELECT COUNT(*) as count FROM users",
    'staff' => "SELECT COUNT(*) as count FROM staff",
    'staff_assignments' => "SELECT COUNT(*) as count FROM staff_assignments",
    'bookings' => "SELECT COUNT(*) as count FROM bookings"
];

foreach ($tables_data as $table => $query) {
    $result = $conn->query($query);
    if ($result) {
        $row = $result->fetch_assoc();
        echo "<p><strong>$table:</strong> " . $row['count'] . " records</p>";
    }
}
?>
